package EmbededTomcat;


public class EmbeddedTomcat {

	private String path = null;

	private Embedded embed = null;

	private Host host = null;

	/**
	 * Default Constructor
	 */
	public EmbeddedTomcat() {
	}

	/**
	 * Basic Accessor setting the value of the context path
	 * 
	 * @param path -
	 *            the path
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * Basic Accessor returning the value of the context path
	 * 
	 * @return - the context path
	 */
	public String getPath() {
		return path;
	}

	/**
	 * This method Starts the Tomcat server.
	 */
	public void startTomcat() throws Exception {

		Engine engine = null;

		// Set the home directory
		System.setProperty("catalina.home", getPath());

		// Create an embedded server
		embed = new Embedded();
		embed.setDebug(5);
		embed.setLogger(new SystemOutLogger());

		// Create an engine
		engine = embed.createEngine();
		engine.setDefaultHost("localhost");

		// Create a default virtual host
		host = embed.createHost("localhost", getPath() + "/webapps");
		engine.addChild(host);

		// Create the ROOT context
		Context context = embed.createContext("", getPath() + "webapps/ROOT");
		host.addChild(context);

		// Create the jsp examples context
		Context jspExamplesContext = embed.createContext("/jsp-examples",
				getPath() + "webapps/jsp-examples");
		host.addChild(jspExamplesContext);

		// Create the servlet examples context
		Context servletExamplesContext = embed.createContext(
				"/servlets-examples", getPath() + "webapps/servlets-examples");
		host.addChild(servletExamplesContext);

		// Install the assembled container hierarchy
		embed.addEngine(engine);

		// Assemble and install a default HTTP connector
		InetAddress addr = null;
		Connector connector = embed.createConnector(addr, 8080, false);
		embed.addConnector(connector);

		// Start the embedded server
		embed.start();
	}

	/**
	 * This method Stops the Tomcat server.
	 */
	public void stopTomcat() throws Exception {
		// Stop the embedded server
		embed.stop();
	}

	/**
	 * Registers a WAR
	 * 
	 * @param contextPath -
	 *            the context path under which the application will be
	 *            registered
	 * @param url -
	 *            the URL of the WAR file to be registered.
	 */
	public void registerWAR(String contextPath, URL url) throws Exception {

		if (contextPath == null) {

			throw new Exception("Invalid Path : " + contextPath);
		}
		String displayPath = contextPath;
		if (contextPath.equals("/")) {
			contextPath = "";
		}
		if (url == null) {
			throw new Exception("Invalid WAR : " + url);
		}

		Deployer deployer = (Deployer) host;
		Context context = deployer.findDeployedApp(contextPath);

		if (context != null) {
			throw new Exception("Context " + contextPath + " already Exists!");
		}
		deployer.install(contextPath, url);
	}

	/**
	 * removes a WAR
	 * 
	 * @param contextPath -
	 *            the context path to be removed
	 */
	public void unregisterWAR(String contextPath) throws Exception {

		Context context = host.map(contextPath);
		if (context != null) {
			embed.removeContext(context);
		} else {
			throw new Exception("Context does not exist for named path : "
					+ contextPath);
		}
	}

	public static void main(String args[]) {

		try {

			EmbeddedTomcat tomcat = new EmbeddedTomcat();
			String rootpath = null;
			if (args.length > 0)
				rootpath = args[0];
			else
				throw new Exception("Tomcat's root path is invalid.");
			tomcat.setPath(rootpath);
			tomcat.startTomcat();
			Thread.sleep(60000);
			tomcat.stopTomcat();
			System.exit(0);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}